﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ListyPlacLista.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.ListyPlacLista" Culture="pl-PL" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Listy Płac</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script type="text/javascript" src="../jquery/jquery.blockUI.js"></script>
    <script language="javascript" type="text/jscript">

        $(function () {
            $("#tbRok").keydown(function (event) {
                // Prevent shift key since its not needed
                if (event.shiftKey == true) {
                    event.preventDefault();
                }
                // Allow Only: keyboard 0-9, numpad 0-9, backspace, tab, left arrow, right arrow, delete
                if ((event.keyCode >= 48 && event.keyCode <= 57) || (event.keyCode >= 96 && event.keyCode <= 105) || event.keyCode == 8 || event.keyCode == 9 || event.keyCode == 37 || event.keyCode == 39 || event.keyCode == 46) {
                    // Allow normal operation
                } else {
                    // Prevent the rest
                    event.preventDefault();
                }
            });
        });



    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <table class="Body" cellspacing="0" cellpadding="0" width="100%" border="0">
                <tr>
                    <td colspan="4"><span style="font-size: 12pt; font-weight: bold">Listy płac</span></td>
                </tr>
                <tr>
                    <td colspan="4">
                        <asp:Label ID="lblError" runat="server" EnableViewState="False"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td valign="bottom" style="width: 35%">
                        <small>Nazwa/numer</small><br />
                        <asp:TextBox ID="tbNumerListy" Style="width: 98%" runat="server"></asp:TextBox>
                    </td>
                    <td valign="bottom" style="width: 25%">
                        <asp:Label ID="lblRodzajMiesiaca" runat="server"><small>Rodzaj miesiąca</small></asp:Label><br />
                        <asp:DropDownList ID="ddlRodzajMiesiaca" runat="server" Style="width: 100%">
                            <asp:ListItem Selected="True" Value="KOSZTU">Kosztowy</asp:ListItem>
                            <asp:ListItem Value="PODATKU">Podatek</asp:ListItem>
                            <asp:ListItem Value="ZUS"></asp:ListItem>
                        </asp:DropDownList></td>
                    <td valign="bottom" style="width: 20%">
                        <asp:Label ID="lblRok" runat="server"><small>Rok</small></asp:Label><br />
                        <asp:TextBox ID="tbRok" Style="width: 96%" runat="server" MaxLength="4"></asp:TextBox></td>
                    <td valign="bottom" style="width: 20%">
                        <asp:Label ID="lblMiesiac" runat="server"><small>Miesiac</small></asp:Label><br />
                        <asp:DropDownList ID="ddlMiesiac" runat="server" Style="width: 100%">
                            <asp:ListItem Value="1">Styczeń</asp:ListItem>
                            <asp:ListItem Value="2">Luty</asp:ListItem>
                            <asp:ListItem Value="3">Marzec</asp:ListItem>
                            <asp:ListItem Value="4">Kwiecień</asp:ListItem>
                            <asp:ListItem Value="5">Maj</asp:ListItem>
                            <asp:ListItem Value="6">Czerwiec</asp:ListItem>
                            <asp:ListItem Value="7">Lipiec</asp:ListItem>
                            <asp:ListItem Value="8">Sierpień</asp:ListItem>
                            <asp:ListItem Value="9">Wrzesień</asp:ListItem>
                            <asp:ListItem Value="10">Październik</asp:ListItem>
                            <asp:ListItem Value="11">Listopad</asp:ListItem>
                            <asp:ListItem Value="12">Grudzień</asp:ListItem>
                        </asp:DropDownList></td>
                </tr>
                <tr>
                    <td valign="bottom">
                        <asp:Label ID="lblJednostka" runat="server">
                        <small>Jednostka</small></asp:Label>
                        <asp:DropDownList ID="ddlJednostka" runat="server" Style="width: 100%">
                        </asp:DropDownList></td>
                    <td valign="bottom">
                        <small>Status</small><br />
                        <asp:DropDownList ID="ddlStatus" runat="server" Width="100%" AutoPostBack="True" OnSelectedIndexChanged="ddlStatus_SelectedIndexChanged">
                            <asp:ListItem Value="ALL" Selected="True">- Wybierz -</asp:ListItem>
                            <asp:ListItem Value="DO_POD">Do podpisu</asp:ListItem>
                            <asp:ListItem Value="POD">Podpisana</asp:ListItem>
                        </asp:DropDownList></td>
                    <td align="right" valign="bottom" colspan="2">
                        <asp:Button ID="btnOdswiez" runat="server" Width="90px" Text="Odśwież" CssClass="Button"
                            OnClick="btnOdswiez_Click"></asp:Button></td>
                </tr>
            </table>
        </div>
        <div>
            <asp:Button ID="btnPodpisz" runat="server" Width="90px" Text="Podpisz" CssClass="Button" OnClick="btnPodpisz_Click" Enabled="False"></asp:Button>
        </div>
        <div id="divPobierzKlucz" style="display: none; width: 600px" runat="server">
            <div style="height: 10px">&nbsp;</div>
            <div style="color: Blue; font-size: 12pt">Wybierz plik z kluczem którym mają zostać podpisane wybrane listy płac</div>
            <asp:FileUpload ID="fuKlucz" runat="server" Style="width: 500px" />
            <div id="divHaslo" style="display: none; width: 500px; border-style: solid; border-width: 1px; border-color: Red; padding-left: 5px; margin-top:5px; margin-bottom:5px;" runat="server">
                <span>Hasło:</span>
                <asp:TextBox ID="tbHaslo" runat="server" TextMode="Password"></asp:TextBox>
                <span style="color: Red;">Wymagane jest podanie hasła.</span>
            </div>
            <div>
                <asp:Button ID="btnPodpiszOk" runat="server" Width="90px" Text="Podpisz" CssClass="Button" OnClick="btnPodpiszOk_Click"></asp:Button>
                <asp:Button ID="btnPodpiszAnuluj" runat="server" Width="90px" Text="Anuluj" CssClass="Button" OnClick="btnPodpiszAnuluj_Click"></asp:Button>
                <div style="height: 10px">&nbsp;</div>
            </div>
        </div>
        <asp:Label ID="lblKomunikat" runat="server" EnableViewState="False"></asp:Label>
        <div>
            <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                <div style="float: left; position: absolute; bottom: 2px;">
                    <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                </div>
                <div style="float: right;">
                    <asp:Button ID="btnZaznaczWszystko" runat="server" CssClass="Button" OnClick="btnZaznaczWszystko_Click"
                        Text="Zaznacz wszystko" Width="140px" Height="22px" />
                    <asp:Button ID="btnOdwrocZaznaczenie" runat="server" CssClass="Button" OnClick="btnOdwrocZaznaczenie_Click"
                        Text="Odwróć zaznaczenie" Width="140px" Height="22px" />
                </div>
            </div>
            <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_LISTY,STATUS" OnRowDataBound="gvListy_RowDataBound">
                <Columns>
                    <asp:TemplateField>
                        <ItemTemplate>
                            <asp:CheckBox ID="cbZaznacz" runat="server" Enabled='<%# ZaznaczEnabled((System.Data.DataRowView)Container.DataItem) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField ShowHeader="False">
                        <ItemTemplate>
                            <asp:Button ID="btnPodglad" runat="server" CausesValidation="false" CommandName="PODGLAD"
                                Text="Podgląd" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="NUMER" HeaderText="Nazwa/Numer" SortExpression="NUMER" />
                    <asp:BoundField DataField="MPZ_NAZWA" HeaderText="Jednostka" SortExpression="MPZ_NAZWA" />
                    <asp:BoundField DataField="OKRES" HeaderText="Okres" SortExpression="OKRES" />
                    <asp:BoundField DataField="OKRES_ZUS" HeaderText="Okres ZUS" SortExpression="OKRES_ZUS" />
                    <asp:BoundField DataField="OKRES_PODATEK" HeaderText="Okres podatek" SortExpression="OKRES_PODATEK" />
                    <asp:BoundField DataField="DATA_WYSLANIA" HeaderText="Data wysłania" DataFormatString="{0:yyyy-MM-dd}" SortExpression="DATA_WYSLANIA" />
                    <asp:BoundField DataField="WYSYLAJACY" HeaderText="Wysyłajacy" SortExpression="WYSYLAJACY" />
                    <asp:BoundField DataField="DATA_PODPISANIA" HeaderText="Data podpisania" DataFormatString="{0:yyyy-MM-dd}" SortExpression="DATA_PODPISANIA" />
                    <asp:BoundField DataField="PODPISUJACY" HeaderText="Podpisujący" SortExpression="PODPISUJACY" />
                    <asp:BoundField DataField="STATUS_NAZWA" HeaderText="Status" SortExpression="STATUS_NAZWA" />
                </Columns>
                <RowStyle CssClass="TableItem" />
                <SelectedRowStyle CssClass="TableItemSelected" />
                <HeaderStyle CssClass="TableHeader" />
                <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            &nbsp;&nbsp;
        <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="LISTY_PLAC_FUNKCJE_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected">
            <SelectParameters>
                <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                <asp:ControlParameter ControlID="tbNumerListy" Name="P_NUMER" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                <asp:ControlParameter ControlID="ddlMiesiac" Name="P_MIESIAC" PropertyName="SelectedValue"
                    Type="Decimal" />
                <asp:ControlParameter ControlID="tbRok" Name="P_ROK" PropertyName="Text" Type="Decimal" />
                <asp:ControlParameter ControlID="ddlRodzajMiesiaca" Name="P_SPOSOB" PropertyName="SelectedValue"
                    Type="String" />
                <asp:ControlParameter ControlID="ddlStatus" Name="P_STATUS" PropertyName="SelectedValue"
                    Type="String" />
                <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />
            </SelectParameters>
        </asp:SqlDataSource>
            &nbsp;
    
        </div>
    </form>
</body>
</html>
